package Tools;

import java.io.*;

/**
 * A TeeOutputStream makes a copy of every write onto another stream
 * on the side.
 * <p>Note: the primary stream is given first shot at
 * the write; if it throws an exception, the secondary stream doesn't
 * see the write.
 */
public class TeeOutputStream
	extends FilterOutputStream {

	OutputStream tee;

	public TeeOutputStream(OutputStream primary,
		OutputStream secondary) {
		super(primary);
		this.tee = secondary;
	}

	public void write(int b) throws IOException {
		out.write(b);
		tee.write(b);
	}
	
	public void write(byte b[]) throws IOException {
		out.write(b);
		tee.write(b);
	}

	public void write(byte b[], int off, int len) throws IOException {
		out.write(b, off, len);
		tee.write(b, off, len);
	}

	public void close() throws IOException {
		tee.close();
	}

	public void flush() throws IOException {
		tee.flush();
	}
}
