package Tools;

import java.util.*;

/**
 * A class used to hash uniquely on a combination of inputs. Two HashKeys are
 * equal (and have the same hashcode) when the same is true of all of
 * their members, pairwise. 
 */
public class HashKey
	extends Vector {

	public boolean equals(Object o) {
		if (!(o instanceof HashKey)) {
			return false;
		}
		HashKey ohk = (HashKey) o;
		if (ohk.size()!=size()) {
			return false;
		}
		for (int i=0; i<size(); i++) {
			if (!ohk.elementAt(i).equals(elementAt(i))) {
				return false;
			}
		}
		return true;
	}

	public int hashCode() {
		int hc=0;
		for (int i=0; i<size(); i++) {
			hc = hc ^ elementAt(i).hashCode();
		}
		return hc;
	}
}
