package Tools;

/**
 * Tools to transfer multibyte data into and out of byte[] arrays, with
 * either endianness.
 * 
 * @rcs $Id: Endian.java,v 1.2 2000/05/22 01:32:30 jonh Exp $ 
 */
public class Endian {
	public static long LittleGetLong(byte[] b, int off) {
		return
			((long)(b[off+0]&0xff)) |
			((long)(b[off+1]&0xff) << 8) |
			((long)(b[off+2]&0xff) << 16) |
			((long)(b[off+3]&0xff) << 24) |
			((long)(b[off+4]&0xff) << 32) |
			((long)(b[off+5]&0xff) << 40) |
			((long)(b[off+6]&0xff) << 48) |
			((long)(b[off+7]&0xff) << 56);
	}

	public static void LittlePutLong(byte[] b, int off, long value) {
		b[off+0] = (byte) (value 		& 0xff);
		b[off+1] = (byte) ((value >> 8)	& 0xff);
		b[off+2] = (byte) ((value >> 16)& 0xff);
		b[off+3] = (byte) ((value >> 24)& 0xff);
		b[off+4] = (byte) ((value >> 32)& 0xff);
		b[off+5] = (byte) ((value >> 40)& 0xff);
		b[off+6] = (byte) ((value >> 48)& 0xff);
		b[off+7] = (byte) ((value >> 56)& 0xff);
	}

	public static int LittleGetInt(byte[] b, int off) {
		return
			((int)(b[off+0]&0xff)) |
			((int)(b[off+1]&0xff) << 8) |
			((int)(b[off+2]&0xff) << 16) |
			((int)(b[off+3]&0xff) << 24);
	}

	public static void LittlePutInt(byte[] b, int off, int value) {
		b[off+0] = (byte) (value 		& 0xff);
		b[off+1] = (byte) ((value >> 8)	& 0xff);
		b[off+2] = (byte) ((value >> 16)& 0xff);
		b[off+3] = (byte) ((value >> 24)& 0xff);
	}

	public static short LittleGetShort(byte[] b, int off) {
		return (short) (
			 (b[off+0]&0xff) |
			((b[off+1]&0xff) << 8));
	}

	public static void LittlePutShort(byte[] b, int off, short value) {
		b[off+0] = (byte) (value 		& 0xff);
		b[off+1] = (byte) ((value >> 8)	& 0xff);
	}

	public static long BigGetLong(byte[] b, int off) {
		return
			((long)(b[off+7]&0xff)) |
			((long)(b[off+6]&0xff) << 8) |
			((long)(b[off+5]&0xff) << 16) |
			((long)(b[off+4]&0xff) << 24) |
			((long)(b[off+3]&0xff) << 32) |
			((long)(b[off+2]&0xff) << 40) |
			((long)(b[off+1]&0xff) << 48) |
			((long)(b[off+0]&0xff) << 56);
	}

	public static void BigPutLong(byte[] b, int off, long value) {
		b[off+7] = (byte) (value 		& 0xff);
		b[off+6] = (byte) ((value >> 8)	& 0xff);
		b[off+5] = (byte) ((value >> 16)& 0xff);
		b[off+4] = (byte) ((value >> 24)& 0xff);
		b[off+3] = (byte) ((value >> 32)& 0xff);
		b[off+2] = (byte) ((value >> 40)& 0xff);
		b[off+1] = (byte) ((value >> 48)& 0xff);
		b[off+0] = (byte) ((value >> 56)& 0xff);
	}

	public static int BigGetInt(byte[] b, int off) {
		return
			((int)(b[off+3]&0xff)) |
			((int)(b[off+2]&0xff) << 8) |
			((int)(b[off+1]&0xff) << 16) |
			((int)(b[off+0]&0xff) << 24);
	}

	public static void BigPutInt(byte[] b, int off, int value) {
		b[off+3] = (byte) (value 		& 0xff);
		b[off+2] = (byte) ((value >> 8)	& 0xff);
		b[off+1] = (byte) ((value >> 16)& 0xff);
		b[off+0] = (byte) ((value >> 24)& 0xff);
	}

	public static short BigGetShort(byte[] b, int off) {
		return (short) (
			 (b[off+1]&0xff) |
			((b[off+0]&0xff) << 8));
	}

	public static void BigPutShort(byte[] b, int off, short value) {
		b[off+1] = (byte) (value 		& 0xff);
		b[off+0] = (byte) ((value >> 8)	& 0xff);
	}
}
