package Tools;

/**
 * When profiling, the program must exit without a signal. But if
 * you're trying to profile an RMI call, you can't System.exit() before
 * you return() your results, or you miss the reply time. So this class
 * lets you set a timer, then exit after the return call has completed.
 */
public class DeadManSwitch extends Thread {
	public static void setTimer(long millis) {
		(new DeadManSwitch(millis)).start();
	}

	long millis;

	DeadManSwitch(long millis) {
		this.millis = millis;
	}

	public void run() {
		try {
			Thread.sleep(millis);
			System.exit(0);
		} catch (InterruptedException ex) {
			ex.printStackTrace();
		}
	}
}
