package Tools;

/**
 * Tools to manipulate arrays.
 * Some of these are obsolete with the introduction of
 * <code>java.util.Arrays</code> in JDK 1.2.
 */
public class Arrays {

	// There must be a way to do these functions that's
	// built into Java, and I just haven't noticed it yet.

	public static void zeroByteArray(byte[] a) {
		zeroByteArray(a, 0, a.length);
	}

	public static void zeroByteArray(byte[] a, int start, int length) {
		setByteArray(a, (byte) 0, start, length);
	}

	public static void setByteArray(byte[] a, byte val, int start, int length) {
		int i;
		int end = start+length;
		for (i=start; i<end; i++) {
			a[i] = val;
		}
	}

	public static boolean equals(byte[] a, byte[] b) {
		if (a.length!=b.length)
			return false;
		for (int i=0; i<a.length; i++) {
			if (a[i]!=b[i])
				return false;
		}
		return true;
	}

	public static void zeroIntArray(int[] a) {
		zeroIntArray(a, 0, a.length);
	}

	public static void zeroIntArray(int[] a, int start, int length) {
		setIntArray(a, (int) 0, start, length);
	}

	public static void setIntArray(int[] a, int val, int start, int length) {
		int i;
		int end = start+length;
		for (i=start; i<end; i++) {
			a[i] = val;
		}
	}

	public static String dumpBytes(byte[] bytes) {
		return dumpBytes(bytes, 0, bytes.length);
	}

	public static String dumpBytes(byte[] bytes, int off, int len) {
		int i, count;
		StringBuffer sb = new StringBuffer();
		for (i=off, count=0; i<len; i++, count++) {
			if (count%32 == 0 && count!=0) {
				sb.append("\n");
			}
			String s = Integer.toHexString(bytes[i]);
			if (s.length() < 2) {
				s = "0"+s;
			}
			if (s.length() > 2) {
				s = s.substring(s.length()-2);
			}
			sb.append(s);
		}
		return sb.toString();
	}
}
